<?php

set_time_limit(0);
ini_set('memory_limit', '-1');
require_once("includes/config.php");

require_once("includes/etsyv3/vendor/autoload.php");
use OAuth\Client;

$logfile = fopen("logs/updateshopifyinventory1217_v3_test.txt", "a+") or die("Unable to open log file!");
addlog("Execution Started", "INFO");


	
$cronQuery = $conn->query("select isrunning from crons where crontype = 'updateshopifyinventory1217_v3'");
$cronrow = $cronQuery->fetch_assoc();
if($cronrow['isrunning'] == 1){
	@mail("khariwal.rohit@gmail.com", "ETSY: updateshopifyinventory1217_v3: Cron already running", "updateshopifyinventory1217_v3: Cron already running");
	die("");
}
	
$conn->query("update crons set lastrun = now(), isrunning = 1 where crontype = 'updateshopifyinventory1217_v3'");

$result = $conn->query("select u.id as user_id, u.shopurl, u.token, s.inventory_sync, s.price_sync, eb.*, s.shopifylocationid from users u, setting s, etsy_keys eb where eb.user_id = u.id and s.user_id = u.id and eb.valid = 1 and (s.inventory_sync = 1 or s.price_sync = 1) and u.status = 'active' and u.installationstatus = 1 and eb.apiversion = 'v3' and u.id = 1217");

if ($result->num_rows > 0) {
	while($row = $result->fetch_assoc()) {	
		$id = $row['user_id'];
		$shopurl = $row['shopurl'];
		$token = $row['token'];		
		$shop_id = $row['shop_id'];
		$oauth_token = $row['oauth_token'];
		$oauth_token_secret = $row['oauth_token_secret'];
		$location_id = $row['shopifylocationid'];
        $access_token = $row['access_token'];
		$refresh_token = $row['refresh_token'];
		if($location_id == ""){
			$location_id = getMainLocation($id, $shopurl, $token);
			if(!$location_id){
				@mail("khariwal.rohit@gmail.com", "ETSY:updateshopifyinventory1217_v3 Location ID missing", $id);
				continue;
			}
		}
		$inventory_sync=0;
		$price_sync=0;


		$inventory_sync = $row['inventory_sync'];
		$price_sync = $row['price_sync'];		
		addlog("fetchFromEtsy: Process started for user_id - ".$id, "INFO");
		fetchFromEtsy($id, $shop_id, $access_token, $refresh_token);
		
		addlog("updateInventoryAndPrice: Process started for user_id - ".$id, "INFO");
		mysqli_autocommit($conn, FALSE);
		
		markinactive($id);
		echo "done";
		updateInventoryAndPrice($id, $token, $shopurl, $inventory_sync, $price_sync, $location_id);
                echo "price updated"; 	
		mysqli_commit($conn);		
	}
}
mysqli_autocommit($conn, TRUE);
$conn->query("update crons set isrunning = 0 where crontype = 'updateshopifyinventory1217_v3'");
function markinactive($user_id){
	global $conn,$etsyConfig;
	$result = $conn->query("select * from products where   etsy_state !='active' and  user_id = ".$user_id);
	//echo "select * from products where  etsy_state = 'inactive' and  user_id = ".$user_id;
	if($result->num_rows > 0){
		while($row = $result->fetch_assoc()){
			$product_id = $row['product_id'];

			$conn->query("update product_variants set quantity = 0, quantityflag = 1  where product_id = '".$product_id."' and user_id =".$user_id );
		   echo " inactive updated";
		}

	}
	return true;

}
function fetchFromEtsy($user_id, $shop_id, $access_token, $refresh_token) {
	global $conn,$etsyConfig;
	$api_key = $etsyConfig['api_key'];
	// Prepare existing data in array
	$existingItems = array();
	$result = $conn->query("select * from product_variants where user_id = ".$user_id);
	if($result->num_rows > 0){
		while($row = $result->fetch_assoc()){
			$product_id = $row['product_id'];
			$variant_id = $row['id'];
			$option1val = $row['option1val'];
			$option2val = $row['option2val'];
			$option3val = $row['option3val'];
			$price = $row['price'];
			$quantity = $row['quantity'];
		
			$productResult = $conn->query("select * from products where product_id = ".$product_id." and user_id = ".$user_id);
			if($productResult->num_rows < 1){
				continue;
			}
			$productRow = $productResult->fetch_assoc();
			$etsylistingid = $productRow['etsylistingid'];
			$option1name = $productRow['option1name'];
			$option2name = $productRow['option2name'];
			$option3name = $productRow['option3name'];

			$temp = array("etsylistingid" => $etsylistingid, "price" => $price, "quantity" => $quantity, "variant_id" => $variant_id);
			print_r("from db".json_encode($temp));
			if(strlen($option1name) > 0){
				$temp[$option1name] = $option1val;
			}
			if(strlen($option2name) > 0){
				$temp[$option2name] = $option2val;
			}
			if(strlen($option3name) > 0){
				$temp[$option3name] = $option3val;
			}			
			$existingItems[$etsylistingid][] = $temp;		
		}
	}	
	
	$productResult = $conn->query("select * from products where user_id = '".$user_id."' ");
	if($productResult->num_rows > 0){
		while($productRow = $productResult->fetch_assoc()){
			$product_id = $productRow['product_id'];
			$etsylistingid = $productRow['etsylistingid'];
			if(!array_key_exists($etsylistingid, $existingItems)){
				continue;
			}
			$existingItemData = $existingItems[$etsylistingid];		
			try {
			    $header = array("Authorization: Bearer ".$access_token,"x-api-key: ".$api_key);
			    $curl = curl_init();
				curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://openapi.etsy.com/v3/application/listings/'.$etsylistingid.'/inventory',
                    CURLOPT_HTTPHEADER => $header,
                    CURLOPT_SSL_VERIFYPEER => false,
                    CURLOPT_RETURNTRANSFER => true
                ));
                $response_body1 = curl_exec($curl);
                curl_close($curl);	
                $inventoryData = json_decode($response_body1);
				print_r($inventoryData);
				// die();
               
                if(isset($inventoryData->error) && $inventoryData->error == 'invalid_token'){  	 
                    $client = new Etsy\OAuth\Client($api_key);
                    $refreshTokenArray = $client->refreshAccessToken($refresh_token);
                    if(isset($refreshTokenArray->access_token)){
                        $access_token = $refreshTokenArray->access_token;
                        $refresh_token = $refreshTokenArray->refresh_token;
                        $conn->query("update etsy_keys set access_token = '".mysqli_real_escape_string($conn, $refreshTokenArray->access_token)."',refresh_token = '".mysqli_real_escape_string($conn, $refreshTokenArray->refresh_token)."', updated_at = now() where user_id = ".$user_id); 
                        $header = array("Authorization: Bearer ".$refreshTokenArray->access_token,"x-api-key: ".$api_key);
        			    $curl = curl_init();
        				curl_setopt_array($curl, array(
                            CURLOPT_URL => 'https://openapi.etsy.com/v3/application/listings/'.$etsylistingid.'/inventory',
                            CURLOPT_HTTPHEADER => $header,
                            CURLOPT_SSL_VERIFYPEER => false,
                            CURLOPT_RETURNTRANSFER => true
                        ));
                        $response_body1 = curl_exec($curl);
                        curl_close($curl);	
                        $inventoryData = json_decode($response_body1);
                    }
                }
    			
        		//print_r($inventoryData);
			} catch (OAuthException $e) {
    			//print_r($e);
    			error_log($e->getMessage());
    			error_log(print_r($oauth->getLastResponse(), true));
    			error_log(print_r($oauth->getLastResponseInfo(), true));
		    }
			print_r("from etsy".json_encode($inventoryData));
			
			if($productRow['option1name'] == ""){ // Without variants
				$price = 0.0;
				$quantity = 0;
                if(isset($inventoryData->products[0]->offerings[0]->price->amount)){
					$price = $inventoryData->products[0]->offerings[0]->price->amount / 100;
					$price = str_replace(",","",$price);
				}
				
				if(isset($inventoryData->products[0]->offerings[0]->quantity)){
					$quantity = $inventoryData->products[0]->offerings[0]->quantity;
				}
				
									
				
					$conn->query("update product_variants set price = '".mysqli_real_escape_string($conn, $price)."', quantity = '".mysqli_real_escape_string($conn, $quantity)."', priceflag = 1, quantityflag = 1 where id = ".$existingItemData[0]['variant_id']." and user_id = ".$user_id);
					echo "variant id".$existingItemData[0]['variant_id']."variants quantity".$quantity['quantity']."price".$price;
					echo "update product_variants set price = '".mysqli_real_escape_string($conn, $price)."', quantity = '".mysqli_real_escape_string($conn, $quantity)."', priceflag = 1, quantityflag = 1 where id = ".$existingItemData[0]['variant_id']." and user_id = ".$user_id;

				
			} else {
				$variations = array();
				$option1name = "";
				$option2name = "";
				$option3name = "";
				if(isset($inventoryData->products)){								
					$varLength = count($inventoryData->products);
					for($i = 0; $i < $varLength; $i++) {
						$variations[$i] = array();
						if(isset($inventoryData->products[$i]->product_id)){
							$variations[$i]['sku'] = $inventoryData->products[$i]->sku;
						} else {
							$variations[$i]['sku'] = "";
						}
						if(isset($inventoryData->products[$i]->property_values[0]->property_name) && isset($inventoryData->products[$i]->property_values[0]->values[0])){
							$variations[$i][$inventoryData->products[$i]->property_values[0]->property_name] = $inventoryData->products[$i]->property_values[0]->values[0];
						}
						
						if(isset($inventoryData->products[$i]->property_values[1]->property_name) && isset($inventoryData->products[$i]->property_values[1]->values[0])){
							$variations[$i][$inventoryData->products[$i]->property_values[1]->property_name] = $inventoryData->products[$i]->property_values[1]->values[0];
						}

						if(isset($inventoryData->products[$i]->offerings[0]->price->amount)){
							$variations[$i]['price'] = $inventoryData->products[$i]->offerings[0]->price->amount /100;
							$variations[$i]['price'] = str_replace(",","",$variations[$i]['price']);
						} else {
							$variations[$i]['price'] = 0;
						}

						if(isset($inventoryData->products[$i]->offerings[0]->quantity)){
							$variations[$i]['quantity'] = $inventoryData->products[$i]->offerings[0]->quantity;
						} else {
							$variations[$i]['quantity'] = 0;
						}
					}
				}
		//		print_r($variations);
				foreach($variations as $variation){
					foreach($existingItemData as $pk => $existingVariation){
						$ismatched = true;
						foreach($existingVariation as $k => $v){
							if($k == 'sku' || $k == 'processed' || $k == 'orig_price' || $k == 'price' || $k == 'etsylistingid' || $k == 'quantity' || $k == 'variant_id'){
								continue;
							}
						//	echo $variation[$k].'--'.$v.'--'.($variation[$k] != $v)."<br /><br />";
							if($variation[$k] != $v){
								$ismatched = false;
								break;
							}
						}
						if(!$ismatched){
							continue;
						}
						$existingItemData[$pk]['processed'] = 1;
						$priceflag = 0;
						$quantityflag = 0;
													
						echo "variant id". $existingVariation['variant_id']."variants quantity".$variation['quantity']."price".$variation['price'];
							$conn->query("update product_variants set price = '".mysqli_real_escape_string($conn, $variation['price'])."', quantity = '".mysqli_real_escape_string($conn, $variation['quantity'])."', priceflag = 1, quantityflag = 1 where id = '".$existingVariation['variant_id']."' and user_id = ".$user_id);
							echo "update product_variants set price = '".mysqli_real_escape_string($conn, $variation['price'])."', quantity = '".mysqli_real_escape_string($conn, $variation['quantity'])."', priceflag = 1, quantityflag = 1 where id = '".$existingVariation['variant_id']."' and user_id = ".$user_id;
						break;							
					}
				}
				foreach($existingItemData as $existingVariation){
					if(!isset($existingVariation['processed']) && $existingVariation['quantity'] > 0){
						$conn->query("update product_variants set quantity = 0, quantityflag = 1 where id = '".$existingVariation['variant_id']."' and user_id =".$user_id );
					}
				}
			}
		}
	}				
}

function updateInventoryAndPrice($user_id, $token, $shopurl, $inventory_sync, $price_sync, $location_id){
	global $conn;	
	$amzUpdatesArr = array();
	$result = $conn->query("select * from product_variants where shopifyvariantid != '' and (quantityflag = 1 or priceflag = 1) and  block = 0 and deleted = 0   and user_id = ".$user_id);
	if ($result->num_rows > 0) {
		$i = 0;
		while($row = $result->fetch_assoc()) {	
			print_r($row);		
			$rowid = $row['id'];
			$shopifyvariantid = $row['shopifyvariantid'];
			$shopifyinventoryid = $row['shopifyinventoryid'];
			$shopifylocationid = $row['shopifylocationid'];
			$shopifyproductid = $row['shopifyproductid'];
			if($shopifylocationid == ''){
				$shopifylocationid = $location_id;
			}
			$priceflag = $row['priceflag'];
			$quantityflag = $row['quantityflag'];
			$sku = $row['sku'];					
			$quantity = $row['quantity'];
			$price = $row['price'];
			$price = $price- $row['price'] * 0.03;
			$price = round($price);
			$data = array();
			addlog("before update shopify variant ".$shopifyvariantid,"INFO");
			if($price_sync == 1 && $priceflag == 1){
				echo "kgjfkhdfjgfd".$shopifyvariantid;
				//die();
				addlog("inside of condition ".$shopifyvariantid,"INFO");
				$data = array(
							"variant"=>array(
								"id" => $shopifyvariantid,		
								"price" => number_format($price, 2, '.', '')
							)
						);			
						addlog("updateShopifyVariant data ".json_encode($data,true),"INFO");	
				$res = updateShopifyVariant($token, $shopurl, $shopifyproductid, $data, $rowid, $user_id);
				if($res){
					$conn->query("update product_variants set priceflag = 0 where id = ".$rowid);
					$i++;
				}
			}
			if($inventory_sync == 1 && $quantityflag == 1 && $shopifyinventoryid == ''){
				$shopifyinventoryid = getInventoryId($user_id, $token, $shopurl, $shopifyvariantid);
				$conn->query("update product_variants set shopifyinventoryid = '".mysqli_real_escape_string($conn, $shopifyinventoryid)."' where user_id = ".$user_id." and id = ".$rowid);
			}
			if($inventory_sync == 1 && $quantityflag == 1 && $shopifyinventoryid != ''){
				addlog("updateShopifyInventory data : ","INFO");
				$res = updateShopifyInventory($rowid, $user_id, $token, $shopurl, $shopifyinventoryid, $shopifylocationid, $quantity);
				if($res){
					$conn->query("update product_variants set quantityflag = 0 where id = ".$rowid);
					$i++;
				}
			}				
			if($i > 50){
				echo "incommit";
				mysqli_commit($conn);
				$i = 0;
			}
		}
		mysqli_commit($conn);		
	}
}
function updateShopifyVariant($token, $shopurl, $product_id, $data, $rowid, $user_id) {
    global $conn;
    echo '3';
    
    $variantId = $data['variant']['id'];  
    $price = number_format($data['variant']['price'], 2, '.', '');

    $queryProductVariantsBulkUpdate = <<<QUERY
    mutation productVariantsBulkUpdate(\$productId: ID!, \$variants: [ProductVariantsBulkInput!]!) {
      productVariantsBulkUpdate(productId: \$productId, variants: \$variants) {
        product {
          id
        }
        productVariants {
          id
          price
        }
        userErrors {
          field
          message
        }
      }
    }
    QUERY;

    $productId = "gid://shopify/Product/".$product_id; 
    $variants = [
        [
            "id" => "gid://shopify/ProductVariant/".$variantId, 
            "price" => $price,
        ]
    ];

    $variablesProductVariants = [
        "productId" => $productId,
        "variants" => $variants,
    ];

    $payloadProductVariants = json_encode([
        "query" => $queryProductVariantsBulkUpdate,
        "variables" => $variablesProductVariants,
    ]);
print_r( $payloadProductVariants);
    $ch = curl_init("https://$shopurl/admin/api/".GRAPHQL_API_VERSION."/graphql.json");

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "X-Shopify-Access-Token: $token"
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payloadProductVariants);

    $responseProductVariants = curl_exec($ch);
   print_r($responseProductVariants);
   
    curl_close($ch);

    $responseDataProductVariants = json_decode($responseProductVariants, true);

    if (isset($responseDataProductVariants['data']['productVariantsBulkUpdate'])) {
        $errors = $responseDataProductVariants['data']['productVariantsBulkUpdate']['userErrors'] ?? [];
        if (!empty($errors)) {
            foreach ($errors as $error) {
                echo "Error: " . $error['message'] . "\n";
            }
            $conn->query("UPDATE product_variants SET quantityflag = 0, priceflag = 0, deleted = 1 WHERE user_id = $user_id AND id = $rowid");
            return false;
        }

        $product = $responseDataProductVariants['data']['productVariantsBulkUpdate']['product'];
        echo "Updated Product ID: " . $product['id'] . "\n";

        $productVariants = $responseDataProductVariants['data']['productVariantsBulkUpdate']['productVariants'];
        foreach ($productVariants as $variant) {
            echo "Variant ID: " . $variant['id'] . "\n";
            echo "Updated Price: " . $variant['price'] . "\n";
        }
        return true;
    } else {
        echo "Product Variants Bulk Update - Unexpected response structure.\n";
        return false;
    }
}


function deleteShopifyProduct($user_id, $token, $shopurl, $product_id){
	global $conn;
	$productId = "gid://shopify/Product/" . $product_id;
	$query = <<<GRAPHQL
	mutation {
		productDelete(input: {id: "$productId"}) {
			deletedProductId
			userErrors {
				field
				message
			}
		}
	}
	GRAPHQL;
	$url = "https://$shopurl/admin/api/".GRAPHQL_API_VERSION."/graphql.json";

	$headers = [
		"Content-Type: application/json",
		"X-Shopify-Access-Token: $token",
	];

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['query' => $query]));

	$response = curl_exec($ch);
	$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	curl_close($ch);

	if ($httpCode !== 200) {
		return false;
	}
	$conn->query("update products set shopifyproductid = '', status ='Ready to Import' where user_id = ".$user_id." and shopifyproductid = '".$product_id."'");
	$conn->query("update product_variants set shopifyproductid = '', shopifyvariantid = '', status ='Ready to Import' where user_id = ".$user_id." and shopifyproductid = '".$product_id."'");
	$conn->query("delete from shopifyproducts where user_id = ".$user_id." and productid = '".$product_id."'");	
	return true;
}

	// Start adding functions to handle multiple location
	function getMainLocation($user_id, $shopurl, $token){
		global $conn;
		$result = $conn->query("select * from locations where user_id = ".$user_id." order by shopifylocationid * 1");
		if($result->num_rows > 0){
			$row = $result->fetch_assoc();
			$location_id = $row['shopifylocationid'];
			return $location_id;
		} else{
			// Try to fetch all possible locations
			$location_id = fetchLocations($user_id, $shopurl, $token);
			if($location_id){
				return $location_id;
			}
		}
		return false;
	}
	
	function fetchLocations($user_id, $shopurl, $token) {
		global $conn;		
		$existingLocations = array();
		$result = $conn->query("select * from locations where user_id = ".$user_id);
		if($result->num_rows > 0){
			while($row = $result->fetch_assoc()){
				$existingLocations[] = $row['shopifylocationid'];
			}
		}
		$apiUrl = "https://$shopurl/admin/api/".GRAPHQL_API_VERSION_LOCATION."/graphql.json";
  
			$query = <<<QUERY
			{
			locations(first: 10) {
				edges {
				node {
					id
					name
					legacyResourceId
				}
				}
			}
			}
			QUERY;
			
		
			$headers = [
				"Content-Type: application/json",
				"X-Shopify-Access-Token: $token"
			];
		
			$postData = json_encode(['query' => $query]);
		
			$ch = curl_init($apiUrl);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
		
			$response = curl_exec($ch);
			$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			curl_close($ch);
		
			if ($httpCode !== 200) {
				return "Error: Unable to fetch data. HTTP Status Code: $httpCode";
			}
		
			$data = json_decode($response, true);
			$locations = $data['data']['locations']['edges'] ?? [];
		foreach ($locations as $location) {
			$name = $location['node']['name'];
			preg_match('/\d+$/', $location['node']['id'], $matches);
			$locationId = $matches[0];
			$shopifylocationid = $locationId;
			if(in_array($shopifylocationid, $existingLocations)){
				continue;
			}
			$legacy = 0;
			if($location['node']['legacyResourceId']){
				$legacy = 1;
			
			}
			$connall->query("insert into locations(name, legacy, status, shopifylocationid, user_id, created_at, updated_at) values('".mysqli_real_escape_string($connall, $locName)."', ".$legacy.", 'active', ".mysqli_real_escape_string($connall, $shopifylocationid).", ".$user_id.", now(), now())");
			$existingLocations[] = $shopifylocationid;
		}
		if(count($existingLocations) > 0){
			sort($existingLocations, SORT_NUMERIC); 
			return $existingLocations[0];
		} else {
			return false;
		}
	}

	function getInventoryId($user_id, $token, $shopurl, $shopifyvariantid){
		global $conn;
		$url = "https://$shopurl/admin/api/".GRAPHQL_API_VERSION."/graphql.json";

		// GraphQL query
		$query = <<<GRAPHQL
		query fetchVariant(\$id: ID!) {
		productVariant(id: \$id) {
			inventoryItem {
			id
			}
		}
		}
		GRAPHQL;

		// Variant ID to fetch
		$variables = [
			"id" => "gid://shopify/ProductVariant/$shopifyvariantid"
		];

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['query' => $query, 'variables' => $variables]));
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			"Content-Type: application/json",
			"X-Shopify-Access-Token: {$token}"
		]);

		$response = curl_exec($ch);
		curl_close($ch);

		$responseData = json_decode($response, true);

		if (isset($responseData['data']['productVariant'])) {
			echo "Variant Details:\n";
			print_r($responseData['data']['productVariant']['inventoryItem']['id']);
			$id = str_replace("gid://shopify/InventoryItem/", "", $responseData['data']['productVariant']['inventoryItem']['id']);
			return $id;
		}
		sleep(1);
		return "";
	}
	function updateShopifyInventory($rowid, $user_id, $token, $shopurl, $inventory_item_id, $location_id, $quantity){
		global $conn;
		$shopifyinventoryid = 'gid://shopify/InventoryItem/'.$inventory_item_id;
			$shopifylocationid = 'gid://shopify/Location/'.$location_id;
		   $quantity = (int) $quantity;
		   echo 'shopify bariehshdf > '.$shopifyinventoryid;
			$query = <<<QUERY
			mutation InventorySet(\$input: InventorySetQuantitiesInput!) {
			  inventorySetQuantities(input: \$input) {
				inventoryAdjustmentGroup {
				  createdAt
				  reason
				  changes {
					name
					delta
				  }
				}
				userErrors {
				  field
				  message
				}
			  }
			}
			QUERY;
		
		
			$variables = [
				"input" => [
					"ignoreCompareQuantity" => true,
					"name" => "available",
					"reason" => "correction",
					"quantities" => [
						[
							"inventoryItemId" => $shopifyinventoryid,
							"locationId" => $shopifylocationid,
							"quantity" => $quantity
						]
					]
				]
			];

			print_r($variables);
		  
			
			$payload = json_encode([
				'query' => $query,
				'variables' => $variables
			]);
			$ch = curl_init("https://$shopurl/admin/api/".GRAPHQL_API_VERSION."/graphql.json");
			
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, [
				"Content-Type: application/json",
				"X-Shopify-Access-Token: $token"
			]);
			
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
			
			$response = curl_exec($ch);
			print_r(json_decode($response,true));
			//die();
			addlog($response,"INFO");
			
			if(curl_errno($ch)) {
				echo 'cURL Error: ' . curl_error($ch);
			}
			$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
			if ($httpCode == 200) {
				$conn->query("update product_variants set shopifylocationid = '".mysqli_real_escape_string($conn, $new_location_id)."' where user_id = ".$user_id." and id = ".$rowid);
				$conn->query("update settings set shopifylocationid = '".mysqli_real_escape_string($conn, $new_location_id)."' where user_id = ".$user_id);
				return true;
			}
			if (($httpCode == 403) || ($httpCode == 422) || ($httpCode == 404)) {
                $conn->query("insert into inventoryerrors (user_id, location_id, inventory_item_id, available, newimport, processed, created_at, updated_at) values (".$user_id.", '".mysqli_real_escape_string($conn, $location_id)."', '".mysqli_real_escape_string($conn, $inventory_item_id)."', ".$quantity.", 0, 0, now(), now())");
				return false;
            }

            if (($httpCode !== 403) || ($httpCode !== 422) || ($httpCode !== 404)) {
                $new_location_id = getLocationId($token, $shopurl, $inventory_item_id);
				$conn->query("update product_variants set shopifylocationid = '".mysqli_real_escape_string($conn, $new_location_id)."' where user_id = ".$user_id." and id = ".$rowid);
				$conn->query("update settings set shopifylocationid = '".mysqli_real_escape_string($conn, $new_location_id)."' where user_id = ".$user_id);
				updateShopifyInventory($rowid, $user_id, $token, $shopurl, $inventory_item_id, $new_location_id, $quantity);
            }
		
			$responseData = json_decode($response, true);
			if (isset($responseData['data']['inventorySetQuantities'])) {
				if(isset($responseData['data']['inventorySetQuantities']['userErrors'][0]['field'])){
					 addlog($responseData['data']['inventorySetQuantities']['userErrors'],"INFO");
					 $conn->query("UPDATE product_variants SET quantityflag = 0, priceflag = 0, deleted = 1 WHERE user_id = $user_id AND id = $rowid");
					 return false;
					}
		
				
				$conn->query("update product_variants set shopifylocationid = '".mysqli_real_escape_string($conn, $location_id)."' where user_id = ".$user_id." and id = ".$rowid);
				$conn->query("update settings set shopifylocationid = '".mysqli_real_escape_string($conn, $location_id)."' where user_id = ".$user_id);
				sleep(1);
				return true;
		}
		$conn->query("insert into inventoryerrors (user_id, location_id, inventory_item_id, available, newimport, processed, created_at, updated_at) values (".$user_id.", '".mysqli_real_escape_string($conn, $location_id)."', '".mysqli_real_escape_string($conn, $inventory_item_id)."', ".$quantity.", 0, 0, now(), now())");

		return false;
	}


	
	function getLocationId($token, $shopurl, $inventory_item_id){	
		$graphqlUrl = "https://$shopurl/admin/api/".GRAPHQL_API_VERSION_LOCATION."/graphql.json"; // Replace 2024-10 with your API version

		// Define the GraphQL query
		$query = <<<GRAPHQL
				{
				inventoryItem(id: "gid://shopify/InventoryItem/$inventory_item_id") {
					inventoryLevels(first: 1) {
					edges {
						node {
						id
						location {
							id
							name
						}
						}
					}
					}
				}
				}
				GRAPHQL;

		// Initialize cURL session
		$ch = curl_init($graphqlUrl);

		// Set cURL options
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			'Content-Type: application/json',
			'X-Shopify-Access-Token: ' . $token
		]);

		// Prepare the payload
		$data = json_encode(['query' => $query]);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

		// Execute the cURL request
		$response = curl_exec($ch);


		$response = json_decode($response,true);
		// print_r($response['data']['inventoryItem']['inventoryLevels']['edges'][0]['node']['location']['id']);

		$pattern = '/gid:\/\/shopify\/Location\//'; // The regex pattern to match the string
		$replacement = ''; // We replace it with an empty string (i.e., remove it)

		$locationId = preg_replace($pattern, $replacement, $response['data']['inventoryItem']['inventoryLevels']['edges'][0]['node']['location']['id']);

		return $locationId;	
	}	

function addlog($message, $type){
    global $logfile;
    $txt = date("Y-m-d H:i:s")." [".$type."]: ".$message."\n";
    fwrite($logfile, $txt);
}
addlog("Execution Finished", "INFO");
fclose($logfile);

?>